; mxcsr.asm
extern printf
extern print_mxcsr
extern print_hex
section .data							
	eleven	dq	11.0					
	two		dq	2.0
   	three 	dq  	3.0
 	ten 		dq  	10.0
   	zero    	dq  	0.0
	hex		db	"0x",0
	fmt1		db	10,"Dzielenie, domyślna wartość mxcsr:",10,0
	fmt2		db	10,"Dzielenie przez zero, domyślna wartość mxcsr:",10,0
  	fmt4    	db  10,"Dzielenie, zaokrąglanie w górę:",10,0
  	fmt5    	db 	10,"Dzielenie, zaokrąglanie w dół:",10,0
   	fmt6    	db  10,"Dzielenie, przycinanie:",10,0        						
	f_div	db	"%.1f dzielone prez %.1f równa się %.16f, szesnastkowo: ",0
  	f_before 	db 	10,"mxcsr przed operacją:",9,0
   	f_after 	db 	"mxcsr po operacji:",9,0

; wartości mxcsr
	default_mxcsr	dd 0001110110000000b
	round_nearest	dd 0001111110000000b
	round_down		dd 0011111110000000b
	round_up		dd 0101111110000000b
	truncate		dd 0111111110000000b

section .bss
        mxcsr_before 	resd    1
        mxcsr_after   	resd    1
        xmm 			resq 	1
section .text							
	global main					
main:
push rbp
mov	rbp,rsp

;dzielenie
;domyślna wartość mxcsr
	mov 	rdi,fmt1
	mov 	rsi,ten
	mov 	rdx,two
	mov 	ecx, [default_mxcsr]
	call apply_mxcsr
;----------------------------------------------
;dzielenie z błędem precyzji
;domyślna wartość mxcsr
	mov 	rdi,fmt1
	mov 	rsi,ten
	mov 	rdx,three
	mov 	ecx, [default_mxcsr]
	call apply_mxcsr
;dzielenie przez zero
;domyślna wartość mxcsr
	mov 	rdi,fmt2
	mov 	rsi,ten
	mov 	rdx,zero
	mov 	ecx, [default_mxcsr]
	call apply_mxcsr
;dzielenie z błędem precyzji
;zaokrąglanie w górę
	mov 	rdi,fmt4
	mov 	rsi,ten
	mov 	rdx,three
	mov 	ecx, [round_up]
	call apply_mxcsr
;dzielenie z błędem precyzji
;zaokrąglanie w dół
	mov 	rdi,fmt5
	mov 	rsi,ten
	mov 	rdx,three
	mov 	ecx, [round_down]
	call apply_mxcsr
;dzielenie z błędem precyzji
;przycinanie
	mov 	rdi,fmt6
	mov 	rsi,ten
	mov 	rdx,three
	mov 	ecx, [truncate]
	call apply_mxcsr
;----------------------------------------------
;dzielenie z błędem precyzji
;domyślna wartość mxcsr
	mov 	rdi,fmt1
	mov 	rsi,eleven
	mov 	rdx,three
	mov 	ecx, [default_mxcsr]
	call apply_mxcsr
;dzielenie z błędem precyzji
;zaokrąglanie w górę
	mov 	rdi,fmt4
	mov 	rsi,eleven
	mov 	rdx,three
	mov 	ecx, [round_up]
	call apply_mxcsr
;dzielenie z błędem precyzji
;zaokrąglanie w dół
	mov 	rdi,fmt5
	mov 	rsi,eleven
	mov 	rdx,three
	mov 	ecx, [round_down]
	call apply_mxcsr
;dzielenie z błędem precyzji
;przycinanie
	mov 	rdi,fmt6
	mov 	rsi,eleven
	mov 	rdx,three
	mov 	ecx, [truncate]
	call apply_mxcsr
leave
ret                                                                                                                         

;funkcja ------------------------------------------------------------    
apply_mxcsr:   
push	rbp
mov 	rbp,rsp
    	push rsi
    	push	rdx
    	push	rcx
    	push	rbp            ; jeszcze raz w celu wyrównania stosu
	call	printf
    	pop 	rbp
    	pop 	rcx
    	pop 	rdx
    	pop 	rsi

	mov 		[mxcsr_before],ecx
    	ldmxcsr 	[mxcsr_before]
    	movsd 	xmm2, [rsi]	; wartość zmiennoprzecinkowa podwójnej precyzji do xmm2
    	divsd 	xmm2, [rdx]	; dzielimy xmm2 
    	stmxcsr [mxcsr_after] 	; zapisujemy mxcsr w pamięci
    	movsd 	[xmm],xmm2  	; na użytek print_xmm
    	mov 	rdi,f_div
    	movsd	xmm0, [rsi]
    	movsd 	xmm1, [rdx]
    	call 	printf
    	call 	print_xmm
;wypisujemy mxcsr
	mov 	rdi,f_before
	call 	printf
	mov 	rdi, [mxcsr_before]
	call 	print_mxcsr
	mov 	rdi,f_after
	call 	printf
	mov 	rdi, [mxcsr_after]
	call	print_mxcsr
leave
ret
;funkcja ------------------------------------------------------------    
print_xmm:
push rbp
mov  rbp,rsp
	mov 	rdi, hex	;wypisujemy 0x
	call printf
    mov 	rcx,8
.loop:
    xor 	rdi,rdi
    mov 	dil,[xmm+rcx-1]
    push rbp
	push rcx
    call print_hex 
    pop 	rcx
	pop rbp
    loop .loop   
leave
ret
